#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples, 
#we welcome you to contact us at SampleCode@melissadata.com also please visit our 
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

require 'mdNameRubyWrapper'


#/********************** LICENSE STRINGS **********************
#*     To unlock the full functionality of Name Object,      *
#*     	     Or to obtain a Demo License String               *
#* please call a sales representative at 1-800-MELISSA ext. 3 *
#*         (1-800-635-4772 x3) for a license string.          *
 #**************************************************************/
        	
License = "License Here"
DataPath = "C:\\Program Files\\Melissa Data\\DQT\\Data"

NameObj = MdNameRubyWrapper::MdName.new() 

if(NameObj.SetLicenseString(License) == false)
  print "License String is not Valid. To unlock the full functionality of Name Object,\n"
  print "please call a sales representative at 1-800-MELISSA ext. 3"
  Process.exit
end

NameObj.SetPathToNameFiles(DataPath)
if(NameObj.InitializeDataFiles() != 0)
  print NameObj.GetInitializeErrorString()
  Process.exit
end
print "\n ==========================================\n"
print "         NAME OBJECT RUBY EXAMPLE\n"
print " ==========================================\n"
print "            Build Number: "  + NameObj.GetBuildNumber()  + "\n"
print "           Database Date: " + NameObj.GetDatabaseDate() + "\n"
print "Database Expiration Date: " + NameObj.GetDatabaseExpirationDate() + "\n"
print " License Expiration Date: " + NameObj.GetLicenseExpirationDate() + "\n"
print "\n\n"

NameObj.SetFirstNameSpellingCorrection(1)
NameObj.SetPrimaryNameHint(2)
NameObj.SetSalutationPrefix("Dear")
NameObj.SetSalutationSuffix(":")
NameObj.SetSalutationSlug("Valued Customer")

print "Enter FullName: "
temp = gets
Name = temp.chomp

NameObj.SetFullName(Name)
NameObj.Parse()


print "\n"
print "      Prefix: " + NameObj.GetPrefix() + "\n"
print "  First Name: " + NameObj.GetFirstName() + "\n"
print " Middle Name: " + NameObj.GetMiddleName() + "\n"
print "   Last name:  " + NameObj.GetLastName() + "\n"
print "      Suffix:    " + NameObj.GetSuffix() + "\n"
print "      Gender:     " + NameObj.GetGender() + "\n"

print "     Prefix2: " + NameObj.GetPrefix2() + "\n"
print " First Name2: " + NameObj.GetFirstName2() + "\n"
print "Middle Name2: " + NameObj.GetMiddleName2() + "\n"
print "  Last name2:  " + NameObj.GetLastName2() + "\n"
print "     Suffix2:    " + NameObj.GetSuffix2() + "\n"
print "     Gender2:     " + NameObj.GetGender2() + "\n"

print "  Salutation:     " + NameObj.GetSalutation() + "\n"
print "Results Codes...\n"

ResultsString = NameObj.GetResults()
if ((ResultsString.include? "NS01") == true)
    print "NS01: There were no Errors\n"
end
if ((ResultsString.include? "NS03") == true)
    print "NS03: The spelling of the FirstName field was corrected\n"
end
if ((ResultsString.include? "NS04") == true)
    print "NS04: The spelling of the FirstName2 field was corrected\n"
end
if ((ResultsString.include? "NS02") == true)
    print "NS02: There was a parse error...\n"
end
if ((ResultsString.include? "NE01") == true)
    print "Error in Lookup: Phone Prefix Not Valid\n"
end
if ((ResultsString.include? "NE02") == true)
    print "NE01: Two names were detected but the FullName string was not in a recognized format\n"
end
if ((ResultsString.include? "NE03") == true)
    print "NE03: A vulgarity was detected in the name\n"
end
if ((ResultsString.include? "NE04") == true)
    print "NE04: The name contained words found on the list of nuisance names [such as Mickey Mouse]\n"
end
if ((ResultsString.include? "NE05") == true)
    print "NE05: The name contained words normally found in a company name\n"
end
if ((ResultsString.include? "NE06") == true)
    print "NE06: The named contained a non-alphabetic character\n"
    
print "\n\n"    
end